# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .text_element_style import TextElementStyle


class MentionUser(object):
    _types = {
        "user_id": str,
        "text_element_style": TextElementStyle,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.text_element_style: Optional[TextElementStyle] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MentionUserBuilder":
        return MentionUserBuilder()


class MentionUserBuilder(object):
    def __init__(self) -> None:
        self._mention_user = MentionUser()

    def user_id(self, user_id: str) -> "MentionUserBuilder":
        self._mention_user.user_id = user_id
        return self

    def text_element_style(self, text_element_style: TextElementStyle) -> "MentionUserBuilder":
        self._mention_user.text_element_style = text_element_style
        return self

    def build(self) -> "MentionUser":
        return self._mention_user
