# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MergeTableCellsRequest(object):
    _types = {
        "row_start_index": int,
        "row_end_index": int,
        "column_start_index": int,
        "column_end_index": int,
    }

    def __init__(self, d=None):
        self.row_start_index: Optional[int] = None
        self.row_end_index: Optional[int] = None
        self.column_start_index: Optional[int] = None
        self.column_end_index: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MergeTableCellsRequestBuilder":
        return MergeTableCellsRequestBuilder()


class MergeTableCellsRequestBuilder(object):
    def __init__(self) -> None:
        self._merge_table_cells_request = MergeTableCellsRequest()

    def row_start_index(self, row_start_index: int) -> "MergeTableCellsRequestBuilder":
        self._merge_table_cells_request.row_start_index = row_start_index
        return self

    def row_end_index(self, row_end_index: int) -> "MergeTableCellsRequestBuilder":
        self._merge_table_cells_request.row_end_index = row_end_index
        return self

    def column_start_index(self, column_start_index: int) -> "MergeTableCellsRequestBuilder":
        self._merge_table_cells_request.column_start_index = column_start_index
        return self

    def column_end_index(self, column_end_index: int) -> "MergeTableCellsRequestBuilder":
        self._merge_table_cells_request.column_end_index = column_end_index
        return self

    def build(self) -> "MergeTableCellsRequest":
        return self._merge_table_cells_request
