# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .okr_progress_rate import OkrProgressRate
from .text import Text


class OkrKeyResult(object):
    _types = {
        "kr_id": int,
        "confidential": bool,
        "position": int,
        "score": int,
        "visible": bool,
        "weight": float,
        "progress_rate": OkrProgressRate,
        "content": Text,
    }

    def __init__(self, d=None):
        self.kr_id: Optional[int] = None
        self.confidential: Optional[bool] = None
        self.position: Optional[int] = None
        self.score: Optional[int] = None
        self.visible: Optional[bool] = None
        self.weight: Optional[float] = None
        self.progress_rate: Optional[OkrProgressRate] = None
        self.content: Optional[Text] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrKeyResultBuilder":
        return OkrKeyResultBuilder()


class OkrKeyResultBuilder(object):
    def __init__(self) -> None:
        self._okr_key_result = OkrKeyResult()

    def kr_id(self, kr_id: int) -> "OkrKeyResultBuilder":
        self._okr_key_result.kr_id = kr_id
        return self

    def confidential(self, confidential: bool) -> "OkrKeyResultBuilder":
        self._okr_key_result.confidential = confidential
        return self

    def position(self, position: int) -> "OkrKeyResultBuilder":
        self._okr_key_result.position = position
        return self

    def score(self, score: int) -> "OkrKeyResultBuilder":
        self._okr_key_result.score = score
        return self

    def visible(self, visible: bool) -> "OkrKeyResultBuilder":
        self._okr_key_result.visible = visible
        return self

    def weight(self, weight: float) -> "OkrKeyResultBuilder":
        self._okr_key_result.weight = weight
        return self

    def progress_rate(self, progress_rate: OkrProgressRate) -> "OkrKeyResultBuilder":
        self._okr_key_result.progress_rate = progress_rate
        return self

    def content(self, content: Text) -> "OkrKeyResultBuilder":
        self._okr_key_result.content = content
        return self

    def build(self) -> "OkrKeyResult":
        return self._okr_key_result
