# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .okr_progress_rate import OkrProgressRate
from .text import Text


class OkrObjective(object):
    _types = {
        "objective_id": int,
        "confidential": bool,
        "position": int,
        "score": int,
        "visible": bool,
        "weight": float,
        "progress_rate": OkrProgressRate,
        "content": Text,
    }

    def __init__(self, d=None):
        self.objective_id: Optional[int] = None
        self.confidential: Optional[bool] = None
        self.position: Optional[int] = None
        self.score: Optional[int] = None
        self.visible: Optional[bool] = None
        self.weight: Optional[float] = None
        self.progress_rate: Optional[OkrProgressRate] = None
        self.content: Optional[Text] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrObjectiveBuilder":
        return OkrObjectiveBuilder()


class OkrObjectiveBuilder(object):
    def __init__(self) -> None:
        self._okr_objective = OkrObjective()

    def objective_id(self, objective_id: int) -> "OkrObjectiveBuilder":
        self._okr_objective.objective_id = objective_id
        return self

    def confidential(self, confidential: bool) -> "OkrObjectiveBuilder":
        self._okr_objective.confidential = confidential
        return self

    def position(self, position: int) -> "OkrObjectiveBuilder":
        self._okr_objective.position = position
        return self

    def score(self, score: int) -> "OkrObjectiveBuilder":
        self._okr_objective.score = score
        return self

    def visible(self, visible: bool) -> "OkrObjectiveBuilder":
        self._okr_objective.visible = visible
        return self

    def weight(self, weight: float) -> "OkrObjectiveBuilder":
        self._okr_objective.weight = weight
        return self

    def progress_rate(self, progress_rate: OkrProgressRate) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_rate = progress_rate
        return self

    def content(self, content: Text) -> "OkrObjectiveBuilder":
        self._okr_objective.content = content
        return self

    def build(self) -> "OkrObjective":
        return self._okr_objective
