# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class OkrProgressRate(object):
    _types = {
        "mode": str,
        "current": float,
        "percent": float,
        "progress_status": str,
        "start": float,
        "status_type": str,
        "target": float,
    }

    def __init__(self, d=None):
        self.mode: Optional[str] = None
        self.current: Optional[float] = None
        self.percent: Optional[float] = None
        self.progress_status: Optional[str] = None
        self.start: Optional[float] = None
        self.status_type: Optional[str] = None
        self.target: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrProgressRateBuilder":
        return OkrProgressRateBuilder()


class OkrProgressRateBuilder(object):
    def __init__(self) -> None:
        self._okr_progress_rate = OkrProgressRate()

    def mode(self, mode: str) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.mode = mode
        return self

    def current(self, current: float) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.current = current
        return self

    def percent(self, percent: float) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.percent = percent
        return self

    def progress_status(self, progress_status: str) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.progress_status = progress_status
        return self

    def start(self, start: float) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.start = start
        return self

    def status_type(self, status_type: str) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.status_type = status_type
        return self

    def target(self, target: float) -> "OkrProgressRateBuilder":
        self._okr_progress_rate.target = target
        return self

    def build(self) -> "OkrProgressRate":
        return self._okr_progress_rate
