# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class RawContentDocumentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.lang: Optional[int] = None
        self.document_id: Optional[str] = None

    @staticmethod
    def builder() -> "RawContentDocumentRequestBuilder":
        return RawContentDocumentRequestBuilder()


class RawContentDocumentRequestBuilder(object):

    def __init__(self) -> None:
        raw_content_document_request = RawContentDocumentRequest()
        raw_content_document_request.http_method = HttpMethod.GET
        raw_content_document_request.uri = "/open-apis/docx/v1/documents/:document_id/raw_content"
        raw_content_document_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._raw_content_document_request: RawContentDocumentRequest = raw_content_document_request

    def lang(self, lang: int) -> "RawContentDocumentRequestBuilder":
        self._raw_content_document_request.lang = lang
        self._raw_content_document_request.add_query("lang", lang)
        return self

    def document_id(self, document_id: str) -> "RawContentDocumentRequestBuilder":
        self._raw_content_document_request.document_id = document_id
        self._raw_content_document_request.paths["document_id"] = str(document_id)
        return self

    def build(self) -> RawContentDocumentRequest:
        return self._raw_content_document_request
