# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Sheet(object):
    _types = {
        "token": str,
        "row_size": int,
        "column_size": int,
    }

    def __init__(self, d=None):
        self.token: Optional[str] = None
        self.row_size: Optional[int] = None
        self.column_size: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SheetBuilder":
        return SheetBuilder()


class SheetBuilder(object):
    def __init__(self) -> None:
        self._sheet = Sheet()

    def token(self, token: str) -> "SheetBuilder":
        self._sheet.token = token
        return self

    def row_size(self, row_size: int) -> "SheetBuilder":
        self._sheet.row_size = row_size
        return self

    def column_size(self, column_size: int) -> "SheetBuilder":
        self._sheet.column_size = column_size
        return self

    def build(self) -> "Sheet":
        return self._sheet
