# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .text_element_style import TextElementStyle


class TextRun(object):
    _types = {
        "content": str,
        "text_element_style": TextElementStyle,
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.text_element_style: Optional[TextElementStyle] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TextRunBuilder":
        return TextRunBuilder()


class TextRunBuilder(object):
    def __init__(self) -> None:
        self._text_run = TextRun()

    def content(self, content: str) -> "TextRunBuilder":
        self._text_run.content = content
        return self

    def text_element_style(self, text_element_style: TextElementStyle) -> "TextRunBuilder":
        self._text_run.text_element_style = text_element_style
        return self

    def build(self) -> "TextRun":
        return self._text_run
