# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TextStyle(object):
    _types = {
        "align": int,
        "done": bool,
        "folded": bool,
        "language": int,
        "wrap": bool,
    }

    def __init__(self, d=None):
        self.align: Optional[int] = None
        self.done: Optional[bool] = None
        self.folded: Optional[bool] = None
        self.language: Optional[int] = None
        self.wrap: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TextStyleBuilder":
        return TextStyleBuilder()


class TextStyleBuilder(object):
    def __init__(self) -> None:
        self._text_style = TextStyle()

    def align(self, align: int) -> "TextStyleBuilder":
        self._text_style.align = align
        return self

    def done(self, done: bool) -> "TextStyleBuilder":
        self._text_style.done = done
        return self

    def folded(self, folded: bool) -> "TextStyleBuilder":
        self._text_style.folded = folded
        return self

    def language(self, language: int) -> "TextStyleBuilder":
        self._text_style.language = language
        return self

    def wrap(self, wrap: bool) -> "TextStyleBuilder":
        self._text_style.wrap = wrap
        return self

    def build(self) -> "TextStyle":
        return self._text_style
