# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_document_request import CreateDocumentRequest
from ..model.create_document_response import CreateDocumentResponse
from ..model.get_document_request import GetDocumentRequest
from ..model.get_document_response import GetDocumentResponse
from ..model.raw_content_document_request import RawContentDocumentRequest
from ..model.raw_content_document_response import RawContentDocumentResponse


class Document(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateDocumentRequest, option: Optional[RequestOption] = None) -> CreateDocumentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateDocumentResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateDocumentResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateDocumentRequest,
                      option: Optional[RequestOption] = None) -> CreateDocumentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateDocumentResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateDocumentResponse)
        response.raw = resp

        return response

    def get(self, request: GetDocumentRequest, option: Optional[RequestOption] = None) -> GetDocumentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetDocumentResponse = JSON.unmarshal(str(resp.content, UTF_8), GetDocumentResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetDocumentRequest, option: Optional[RequestOption] = None) -> GetDocumentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetDocumentResponse = JSON.unmarshal(str(resp.content, UTF_8), GetDocumentResponse)
        response.raw = resp

        return response

    def raw_content(self, request: RawContentDocumentRequest,
                    option: Optional[RequestOption] = None) -> RawContentDocumentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: RawContentDocumentResponse = JSON.unmarshal(str(resp.content, UTF_8), RawContentDocumentResponse)
        response.raw = resp

        return response

    async def araw_content(self, request: RawContentDocumentRequest,
                           option: Optional[RequestOption] = None) -> RawContentDocumentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: RawContentDocumentResponse = JSON.unmarshal(str(resp.content, UTF_8), RawContentDocumentResponse)
        response.raw = resp

        return response
