# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class AuthPermissionMemberRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.type: Optional[str] = None
        self.action: Optional[str] = None
        self.token: Optional[str] = None

    @staticmethod
    def builder() -> "AuthPermissionMemberRequestBuilder":
        return AuthPermissionMemberRequestBuilder()


class AuthPermissionMemberRequestBuilder(object):

    def __init__(self) -> None:
        auth_permission_member_request = AuthPermissionMemberRequest()
        auth_permission_member_request.http_method = HttpMethod.GET
        auth_permission_member_request.uri = "/open-apis/drive/v1/permissions/:token/members/auth"
        auth_permission_member_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._auth_permission_member_request: AuthPermissionMemberRequest = auth_permission_member_request

    def type(self, type: str) -> "AuthPermissionMemberRequestBuilder":
        self._auth_permission_member_request.type = type
        self._auth_permission_member_request.add_query("type", type)
        return self

    def action(self, action: str) -> "AuthPermissionMemberRequestBuilder":
        self._auth_permission_member_request.action = action
        self._auth_permission_member_request.add_query("action", action)
        return self

    def token(self, token: str) -> "AuthPermissionMemberRequestBuilder":
        self._auth_permission_member_request.token = token
        self._auth_permission_member_request.paths["token"] = str(token)
        return self

    def build(self) -> AuthPermissionMemberRequest:
        return self._auth_permission_member_request
