# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class BaseMember(object):
    _types = {
        "member_type": str,
        "member_id": str,
        "perm": str,
    }

    def __init__(self, d=None):
        self.member_type: Optional[str] = None
        self.member_id: Optional[str] = None
        self.perm: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BaseMemberBuilder":
        return BaseMemberBuilder()


class BaseMemberBuilder(object):
    def __init__(self) -> None:
        self._base_member = BaseMember()

    def member_type(self, member_type: str) -> "BaseMemberBuilder":
        self._base_member.member_type = member_type
        return self

    def member_id(self, member_id: str) -> "BaseMemberBuilder":
        self._base_member.member_id = member_id
        return self

    def perm(self, perm: str) -> "BaseMemberBuilder":
        self._base_member.perm = perm
        return self

    def build(self) -> "BaseMember":
        return self._base_member
