# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .meta_request import MetaRequest


class BatchQueryMetaRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[MetaRequest] = None

    @staticmethod
    def builder() -> "BatchQueryMetaRequestBuilder":
        return BatchQueryMetaRequestBuilder()


class BatchQueryMetaRequestBuilder(object):

    def __init__(self) -> None:
        batch_query_meta_request = BatchQueryMetaRequest()
        batch_query_meta_request.http_method = HttpMethod.POST
        batch_query_meta_request.uri = "/open-apis/drive/v1/metas/batch_query"
        batch_query_meta_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._batch_query_meta_request: BatchQueryMetaRequest = batch_query_meta_request

    def user_id_type(self, user_id_type: str) -> "BatchQueryMetaRequestBuilder":
        self._batch_query_meta_request.user_id_type = user_id_type
        self._batch_query_meta_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: MetaRequest) -> "BatchQueryMetaRequestBuilder":
        self._batch_query_meta_request.request_body = request_body
        self._batch_query_meta_request.body = request_body
        return self

    def build(self) -> BatchQueryMetaRequest:
        return self._batch_query_meta_request
