# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .bitable_table_field_action_value import BitableTableFieldActionValue


class BitableTableFieldAction(object):
    _types = {
        "action": str,
        "field_id": str,
        "before_value": BitableTableFieldActionValue,
        "after_value": BitableTableFieldActionValue,
    }

    def __init__(self, d=None):
        self.action: Optional[str] = None
        self.field_id: Optional[str] = None
        self.before_value: Optional[BitableTableFieldActionValue] = None
        self.after_value: Optional[BitableTableFieldActionValue] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BitableTableFieldActionBuilder":
        return BitableTableFieldActionBuilder()


class BitableTableFieldActionBuilder(object):
    def __init__(self) -> None:
        self._bitable_table_field_action = BitableTableFieldAction()

    def action(self, action: str) -> "BitableTableFieldActionBuilder":
        self._bitable_table_field_action.action = action
        return self

    def field_id(self, field_id: str) -> "BitableTableFieldActionBuilder":
        self._bitable_table_field_action.field_id = field_id
        return self

    def before_value(self, before_value: BitableTableFieldActionValue) -> "BitableTableFieldActionBuilder":
        self._bitable_table_field_action.before_value = before_value
        return self

    def after_value(self, after_value: BitableTableFieldActionValue) -> "BitableTableFieldActionBuilder":
        self._bitable_table_field_action.after_value = after_value
        return self

    def build(self) -> "BitableTableFieldAction":
        return self._bitable_table_field_action
