# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .bitable_table_field_action_value_property_auto_serial import BitableTableFieldActionValuePropertyAutoSerial
from .bitable_table_field_action_value_property_option import BitableTableFieldActionValuePropertyOption


class BitableTableFieldActionValueProperty(object):
    _types = {
        "formatter": str,
        "date_formatter": str,
        "auto_fill": bool,
        "multiple": bool,
        "table_id": str,
        "table_name": str,
        "back_field_name": str,
        "input_type": str,
        "back_field_id": str,
        "auto_serial": BitableTableFieldActionValuePropertyAutoSerial,
        "options": List[BitableTableFieldActionValuePropertyOption],
        "formula_expression": str,
    }

    def __init__(self, d=None):
        self.formatter: Optional[str] = None
        self.date_formatter: Optional[str] = None
        self.auto_fill: Optional[bool] = None
        self.multiple: Optional[bool] = None
        self.table_id: Optional[str] = None
        self.table_name: Optional[str] = None
        self.back_field_name: Optional[str] = None
        self.input_type: Optional[str] = None
        self.back_field_id: Optional[str] = None
        self.auto_serial: Optional[BitableTableFieldActionValuePropertyAutoSerial] = None
        self.options: Optional[List[BitableTableFieldActionValuePropertyOption]] = None
        self.formula_expression: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BitableTableFieldActionValuePropertyBuilder":
        return BitableTableFieldActionValuePropertyBuilder()


class BitableTableFieldActionValuePropertyBuilder(object):
    def __init__(self) -> None:
        self._bitable_table_field_action_value_property = BitableTableFieldActionValueProperty()

    def formatter(self, formatter: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.formatter = formatter
        return self

    def date_formatter(self, date_formatter: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.date_formatter = date_formatter
        return self

    def auto_fill(self, auto_fill: bool) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.auto_fill = auto_fill
        return self

    def multiple(self, multiple: bool) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.multiple = multiple
        return self

    def table_id(self, table_id: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.table_id = table_id
        return self

    def table_name(self, table_name: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.table_name = table_name
        return self

    def back_field_name(self, back_field_name: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.back_field_name = back_field_name
        return self

    def input_type(self, input_type: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.input_type = input_type
        return self

    def back_field_id(self, back_field_id: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.back_field_id = back_field_id
        return self

    def auto_serial(self,
                    auto_serial: BitableTableFieldActionValuePropertyAutoSerial) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.auto_serial = auto_serial
        return self

    def options(self, options: List[
        BitableTableFieldActionValuePropertyOption]) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.options = options
        return self

    def formula_expression(self, formula_expression: str) -> "BitableTableFieldActionValuePropertyBuilder":
        self._bitable_table_field_action_value_property.formula_expression = formula_expression
        return self

    def build(self) -> "BitableTableFieldActionValueProperty":
        return self._bitable_table_field_action_value_property
