# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .export_task import ExportTask


class CreateExportTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[ExportTask] = None

    @staticmethod
    def builder() -> "CreateExportTaskRequestBuilder":
        return CreateExportTaskRequestBuilder()


class CreateExportTaskRequestBuilder(object):

    def __init__(self) -> None:
        create_export_task_request = CreateExportTaskRequest()
        create_export_task_request.http_method = HttpMethod.POST
        create_export_task_request.uri = "/open-apis/drive/v1/export_tasks"
        create_export_task_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_export_task_request: CreateExportTaskRequest = create_export_task_request

    def request_body(self, request_body: ExportTask) -> "CreateExportTaskRequestBuilder":
        self._create_export_task_request.request_body = request_body
        self._create_export_task_request.body = request_body
        return self

    def build(self) -> CreateExportTaskRequest:
        return self._create_export_task_request
