# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class CreateFileSubscriptionResponseBody(object):
    _types = {
        "subscription_id": str,
        "subscription_type": str,
        "is_subcribe": bool,
        "file_type": str,
    }

    def __init__(self, d=None):
        self.subscription_id: Optional[str] = None
        self.subscription_type: Optional[str] = None
        self.is_subcribe: Optional[bool] = None
        self.file_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateFileSubscriptionResponseBodyBuilder":
        return CreateFileSubscriptionResponseBodyBuilder()


class CreateFileSubscriptionResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._create_file_subscription_response_body = CreateFileSubscriptionResponseBody()

    def subscription_id(self, subscription_id: str) -> "CreateFileSubscriptionResponseBodyBuilder":
        self._create_file_subscription_response_body.subscription_id = subscription_id
        return self

    def subscription_type(self, subscription_type: str) -> "CreateFileSubscriptionResponseBodyBuilder":
        self._create_file_subscription_response_body.subscription_type = subscription_type
        return self

    def is_subcribe(self, is_subcribe: bool) -> "CreateFileSubscriptionResponseBodyBuilder":
        self._create_file_subscription_response_body.is_subcribe = is_subcribe
        return self

    def file_type(self, file_type: str) -> "CreateFileSubscriptionResponseBodyBuilder":
        self._create_file_subscription_response_body.file_type = file_type
        return self

    def build(self) -> "CreateFileSubscriptionResponseBody":
        return self._create_file_subscription_response_body
