# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .import_task import ImportTask


class CreateImportTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[ImportTask] = None

    @staticmethod
    def builder() -> "CreateImportTaskRequestBuilder":
        return CreateImportTaskRequestBuilder()


class CreateImportTaskRequestBuilder(object):

    def __init__(self) -> None:
        create_import_task_request = CreateImportTaskRequest()
        create_import_task_request.http_method = HttpMethod.POST
        create_import_task_request.uri = "/open-apis/drive/v1/import_tasks"
        create_import_task_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_import_task_request: CreateImportTaskRequest = create_import_task_request

    def request_body(self, request_body: ImportTask) -> "CreateImportTaskRequestBuilder":
        self._create_import_task_request.request_body = request_body
        self._create_import_task_request.body = request_body
        return self

    def build(self) -> CreateImportTaskRequest:
        return self._create_import_task_request
