# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class CreatePermissionPublicPasswordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.type: Optional[str] = None
        self.token: Optional[str] = None

    @staticmethod
    def builder() -> "CreatePermissionPublicPasswordRequestBuilder":
        return CreatePermissionPublicPasswordRequestBuilder()


class CreatePermissionPublicPasswordRequestBuilder(object):

    def __init__(self) -> None:
        create_permission_public_password_request = CreatePermissionPublicPasswordRequest()
        create_permission_public_password_request.http_method = HttpMethod.POST
        create_permission_public_password_request.uri = "/open-apis/drive/v1/permissions/:token/public/password"
        create_permission_public_password_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_permission_public_password_request: CreatePermissionPublicPasswordRequest = create_permission_public_password_request

    def type(self, type: str) -> "CreatePermissionPublicPasswordRequestBuilder":
        self._create_permission_public_password_request.type = type
        self._create_permission_public_password_request.add_query("type", type)
        return self

    def token(self, token: str) -> "CreatePermissionPublicPasswordRequestBuilder":
        self._create_permission_public_password_request.token = token
        self._create_permission_public_password_request.paths["token"] = str(token)
        return self

    def build(self) -> CreatePermissionPublicPasswordRequest:
        return self._create_permission_public_password_request
