# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteFileCommentReplyRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_type: Optional[str] = None
        self.file_token: Optional[str] = None
        self.comment_id: Optional[int] = None
        self.reply_id: Optional[int] = None

    @staticmethod
    def builder() -> "DeleteFileCommentReplyRequestBuilder":
        return DeleteFileCommentReplyRequestBuilder()


class DeleteFileCommentReplyRequestBuilder(object):

    def __init__(self) -> None:
        delete_file_comment_reply_request = DeleteFileCommentReplyRequest()
        delete_file_comment_reply_request.http_method = HttpMethod.DELETE
        delete_file_comment_reply_request.uri = "/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id"
        delete_file_comment_reply_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._delete_file_comment_reply_request: DeleteFileCommentReplyRequest = delete_file_comment_reply_request

    def file_type(self, file_type: str) -> "DeleteFileCommentReplyRequestBuilder":
        self._delete_file_comment_reply_request.file_type = file_type
        self._delete_file_comment_reply_request.add_query("file_type", file_type)
        return self

    def file_token(self, file_token: str) -> "DeleteFileCommentReplyRequestBuilder":
        self._delete_file_comment_reply_request.file_token = file_token
        self._delete_file_comment_reply_request.paths["file_token"] = str(file_token)
        return self

    def comment_id(self, comment_id: int) -> "DeleteFileCommentReplyRequestBuilder":
        self._delete_file_comment_reply_request.comment_id = comment_id
        self._delete_file_comment_reply_request.paths["comment_id"] = str(comment_id)
        return self

    def reply_id(self, reply_id: int) -> "DeleteFileCommentReplyRequestBuilder":
        self._delete_file_comment_reply_request.reply_id = reply_id
        self._delete_file_comment_reply_request.paths["reply_id"] = str(reply_id)
        return self

    def build(self) -> DeleteFileCommentReplyRequest:
        return self._delete_file_comment_reply_request
