# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .shortcut_info import ShortcutInfo


class File(object):
    _types = {
        "token": str,
        "name": str,
        "type": str,
        "parent_token": str,
        "url": str,
        "shortcut_info": ShortcutInfo,
        "created_time": int,
        "modified_time": int,
        "owner_id": str,
    }

    def __init__(self, d=None):
        self.token: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.parent_token: Optional[str] = None
        self.url: Optional[str] = None
        self.shortcut_info: Optional[ShortcutInfo] = None
        self.created_time: Optional[int] = None
        self.modified_time: Optional[int] = None
        self.owner_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileBuilder":
        return FileBuilder()


class FileBuilder(object):
    def __init__(self) -> None:
        self._file = File()

    def token(self, token: str) -> "FileBuilder":
        self._file.token = token
        return self

    def name(self, name: str) -> "FileBuilder":
        self._file.name = name
        return self

    def type(self, type: str) -> "FileBuilder":
        self._file.type = type
        return self

    def parent_token(self, parent_token: str) -> "FileBuilder":
        self._file.parent_token = parent_token
        return self

    def url(self, url: str) -> "FileBuilder":
        self._file.url = url
        return self

    def shortcut_info(self, shortcut_info: ShortcutInfo) -> "FileBuilder":
        self._file.shortcut_info = shortcut_info
        return self

    def created_time(self, created_time: int) -> "FileBuilder":
        self._file.created_time = created_time
        return self

    def modified_time(self, modified_time: int) -> "FileBuilder":
        self._file.modified_time = modified_time
        return self

    def owner_id(self, owner_id: str) -> "FileBuilder":
        self._file.owner_id = owner_id
        return self

    def build(self) -> "File":
        return self._file
