# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .file_block_change_info import FileBlockChangeInfo


class FileChangeInfo(object):
    _types = {
        "start_time": int,
        "changes": List[FileBlockChangeInfo],
    }

    def __init__(self, d=None):
        self.start_time: Optional[int] = None
        self.changes: Optional[List[FileBlockChangeInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileChangeInfoBuilder":
        return FileChangeInfoBuilder()


class FileChangeInfoBuilder(object):
    def __init__(self) -> None:
        self._file_change_info = FileChangeInfo()

    def start_time(self, start_time: int) -> "FileChangeInfoBuilder":
        self._file_change_info.start_time = start_time
        return self

    def changes(self, changes: List[FileBlockChangeInfo]) -> "FileChangeInfoBuilder":
        self._file_change_info.changes = changes
        return self

    def build(self) -> "FileChangeInfo":
        return self._file_change_info
