# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .reply_content import ReplyContent
from .reply_extra import ReplyExtra


class FileCommentReply(object):
    _types = {
        "reply_id": str,
        "user_id": str,
        "create_time": int,
        "update_time": int,
        "content": ReplyContent,
        "extra": ReplyExtra,
    }

    def __init__(self, d=None):
        self.reply_id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.create_time: Optional[int] = None
        self.update_time: Optional[int] = None
        self.content: Optional[ReplyContent] = None
        self.extra: Optional[ReplyExtra] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileCommentReplyBuilder":
        return FileCommentReplyBuilder()


class FileCommentReplyBuilder(object):
    def __init__(self) -> None:
        self._file_comment_reply = FileCommentReply()

    def reply_id(self, reply_id: str) -> "FileCommentReplyBuilder":
        self._file_comment_reply.reply_id = reply_id
        return self

    def user_id(self, user_id: str) -> "FileCommentReplyBuilder":
        self._file_comment_reply.user_id = user_id
        return self

    def create_time(self, create_time: int) -> "FileCommentReplyBuilder":
        self._file_comment_reply.create_time = create_time
        return self

    def update_time(self, update_time: int) -> "FileCommentReplyBuilder":
        self._file_comment_reply.update_time = update_time
        return self

    def content(self, content: ReplyContent) -> "FileCommentReplyBuilder":
        self._file_comment_reply.content = content
        return self

    def extra(self, extra: ReplyExtra) -> "FileCommentReplyBuilder":
        self._file_comment_reply.extra = extra
        return self

    def build(self) -> "FileCommentReply":
        return self._file_comment_reply
