# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetFileCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_type: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.file_token: Optional[str] = None
        self.comment_id: Optional[int] = None

    @staticmethod
    def builder() -> "GetFileCommentRequestBuilder":
        return GetFileCommentRequestBuilder()


class GetFileCommentRequestBuilder(object):

    def __init__(self) -> None:
        get_file_comment_request = GetFileCommentRequest()
        get_file_comment_request.http_method = HttpMethod.GET
        get_file_comment_request.uri = "/open-apis/drive/v1/files/:file_token/comments/:comment_id"
        get_file_comment_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._get_file_comment_request: GetFileCommentRequest = get_file_comment_request

    def file_type(self, file_type: str) -> "GetFileCommentRequestBuilder":
        self._get_file_comment_request.file_type = file_type
        self._get_file_comment_request.add_query("file_type", file_type)
        return self

    def user_id_type(self, user_id_type: str) -> "GetFileCommentRequestBuilder":
        self._get_file_comment_request.user_id_type = user_id_type
        self._get_file_comment_request.add_query("user_id_type", user_id_type)
        return self

    def file_token(self, file_token: str) -> "GetFileCommentRequestBuilder":
        self._get_file_comment_request.file_token = file_token
        self._get_file_comment_request.paths["file_token"] = str(file_token)
        return self

    def comment_id(self, comment_id: int) -> "GetFileCommentRequestBuilder":
        self._get_file_comment_request.comment_id = comment_id
        self._get_file_comment_request.paths["comment_id"] = str(comment_id)
        return self

    def build(self) -> GetFileCommentRequest:
        return self._get_file_comment_request
