# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetFileStatisticsRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_type: Optional[str] = None
        self.file_token: Optional[str] = None

    @staticmethod
    def builder() -> "GetFileStatisticsRequestBuilder":
        return GetFileStatisticsRequestBuilder()


class GetFileStatisticsRequestBuilder(object):

    def __init__(self) -> None:
        get_file_statistics_request = GetFileStatisticsRequest()
        get_file_statistics_request.http_method = HttpMethod.GET
        get_file_statistics_request.uri = "/open-apis/drive/v1/files/:file_token/statistics"
        get_file_statistics_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_file_statistics_request: GetFileStatisticsRequest = get_file_statistics_request

    def file_type(self, file_type: str) -> "GetFileStatisticsRequestBuilder":
        self._get_file_statistics_request.file_type = file_type
        self._get_file_statistics_request.add_query("file_type", file_type)
        return self

    def file_token(self, file_token: str) -> "GetFileStatisticsRequestBuilder":
        self._get_file_statistics_request.file_token = file_token
        self._get_file_statistics_request.paths["file_token"] = str(file_token)
        return self

    def build(self) -> GetFileStatisticsRequest:
        return self._get_file_statistics_request
