# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .get_file_subscription_request_body import GetFileSubscriptionRequestBody


class GetFileSubscriptionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_token: Optional[str] = None
        self.subscription_id: Optional[str] = None
        self.request_body: Optional[GetFileSubscriptionRequestBody] = None

    @staticmethod
    def builder() -> "GetFileSubscriptionRequestBuilder":
        return GetFileSubscriptionRequestBuilder()


class GetFileSubscriptionRequestBuilder(object):

    def __init__(self) -> None:
        get_file_subscription_request = GetFileSubscriptionRequest()
        get_file_subscription_request.http_method = HttpMethod.GET
        get_file_subscription_request.uri = "/open-apis/drive/v1/files/:file_token/subscriptions/:subscription_id"
        get_file_subscription_request.token_types = {AccessTokenType.USER}
        self._get_file_subscription_request: GetFileSubscriptionRequest = get_file_subscription_request

    def file_token(self, file_token: str) -> "GetFileSubscriptionRequestBuilder":
        self._get_file_subscription_request.file_token = file_token
        self._get_file_subscription_request.paths["file_token"] = str(file_token)
        return self

    def subscription_id(self, subscription_id: str) -> "GetFileSubscriptionRequestBuilder":
        self._get_file_subscription_request.subscription_id = subscription_id
        self._get_file_subscription_request.paths["subscription_id"] = str(subscription_id)
        return self

    def request_body(self, request_body: GetFileSubscriptionRequestBody) -> "GetFileSubscriptionRequestBuilder":
        self._get_file_subscription_request.request_body = request_body
        self._get_file_subscription_request.body = request_body
        return self

    def build(self) -> GetFileSubscriptionRequest:
        return self._get_file_subscription_request
