# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetSubscribeFileRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_type: Optional[str] = None
        self.file_token: Optional[str] = None

    @staticmethod
    def builder() -> "GetSubscribeFileRequestBuilder":
        return GetSubscribeFileRequestBuilder()


class GetSubscribeFileRequestBuilder(object):

    def __init__(self) -> None:
        get_subscribe_file_request = GetSubscribeFileRequest()
        get_subscribe_file_request.http_method = HttpMethod.GET
        get_subscribe_file_request.uri = "/open-apis/drive/v1/files/:file_token/get_subscribe"
        get_subscribe_file_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._get_subscribe_file_request: GetSubscribeFileRequest = get_subscribe_file_request

    def file_type(self, file_type: str) -> "GetSubscribeFileRequestBuilder":
        self._get_subscribe_file_request.file_type = file_type
        self._get_subscribe_file_request.add_query("file_type", file_type)
        return self

    def file_token(self, file_token: str) -> "GetSubscribeFileRequestBuilder":
        self._get_subscribe_file_request.file_token = file_token
        self._get_subscribe_file_request.paths["file_token"] = str(file_token)
        return self

    def build(self) -> GetSubscribeFileRequest:
        return self._get_subscribe_file_request
