# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListFileCommentReplyRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.file_type: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.file_token: Optional[str] = None
        self.comment_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListFileCommentReplyRequestBuilder":
        return ListFileCommentReplyRequestBuilder()


class ListFileCommentReplyRequestBuilder(object):

    def __init__(self) -> None:
        list_file_comment_reply_request = ListFileCommentReplyRequest()
        list_file_comment_reply_request.http_method = HttpMethod.GET
        list_file_comment_reply_request.uri = "/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies"
        list_file_comment_reply_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_file_comment_reply_request: ListFileCommentReplyRequest = list_file_comment_reply_request

    def page_size(self, page_size: int) -> "ListFileCommentReplyRequestBuilder":
        self._list_file_comment_reply_request.page_size = page_size
        self._list_file_comment_reply_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListFileCommentReplyRequestBuilder":
        self._list_file_comment_reply_request.page_token = page_token
        self._list_file_comment_reply_request.add_query("page_token", page_token)
        return self

    def file_type(self, file_type: str) -> "ListFileCommentReplyRequestBuilder":
        self._list_file_comment_reply_request.file_type = file_type
        self._list_file_comment_reply_request.add_query("file_type", file_type)
        return self

    def user_id_type(self, user_id_type: str) -> "ListFileCommentReplyRequestBuilder":
        self._list_file_comment_reply_request.user_id_type = user_id_type
        self._list_file_comment_reply_request.add_query("user_id_type", user_id_type)
        return self

    def file_token(self, file_token: str) -> "ListFileCommentReplyRequestBuilder":
        self._list_file_comment_reply_request.file_token = file_token
        self._list_file_comment_reply_request.paths["file_token"] = str(file_token)
        return self

    def comment_id(self, comment_id: str) -> "ListFileCommentReplyRequestBuilder":
        self._list_file_comment_reply_request.comment_id = comment_id
        self._list_file_comment_reply_request.paths["comment_id"] = str(comment_id)
        return self

    def build(self) -> ListFileCommentReplyRequest:
        return self._list_file_comment_reply_request
