# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .file_comment import FileComment


class ListFileCommentResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "items": List[FileComment],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[FileComment]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListFileCommentResponseBodyBuilder":
        return ListFileCommentResponseBodyBuilder()


class ListFileCommentResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_file_comment_response_body = ListFileCommentResponseBody()

    def has_more(self, has_more: bool) -> "ListFileCommentResponseBodyBuilder":
        self._list_file_comment_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListFileCommentResponseBodyBuilder":
        self._list_file_comment_response_body.page_token = page_token
        return self

    def items(self, items: List[FileComment]) -> "ListFileCommentResponseBodyBuilder":
        self._list_file_comment_response_body.items = items
        return self

    def build(self) -> "ListFileCommentResponseBody":
        return self._list_file_comment_response_body
