# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListFileViewRecordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.file_type: Optional[str] = None
        self.viewer_id_type: Optional[str] = None
        self.file_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListFileViewRecordRequestBuilder":
        return ListFileViewRecordRequestBuilder()


class ListFileViewRecordRequestBuilder(object):

    def __init__(self) -> None:
        list_file_view_record_request = ListFileViewRecordRequest()
        list_file_view_record_request.http_method = HttpMethod.GET
        list_file_view_record_request.uri = "/open-apis/drive/v1/files/:file_token/view_records"
        list_file_view_record_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_file_view_record_request: ListFileViewRecordRequest = list_file_view_record_request

    def page_size(self, page_size: int) -> "ListFileViewRecordRequestBuilder":
        self._list_file_view_record_request.page_size = page_size
        self._list_file_view_record_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListFileViewRecordRequestBuilder":
        self._list_file_view_record_request.page_token = page_token
        self._list_file_view_record_request.add_query("page_token", page_token)
        return self

    def file_type(self, file_type: str) -> "ListFileViewRecordRequestBuilder":
        self._list_file_view_record_request.file_type = file_type
        self._list_file_view_record_request.add_query("file_type", file_type)
        return self

    def viewer_id_type(self, viewer_id_type: str) -> "ListFileViewRecordRequestBuilder":
        self._list_file_view_record_request.viewer_id_type = viewer_id_type
        self._list_file_view_record_request.add_query("viewer_id_type", viewer_id_type)
        return self

    def file_token(self, file_token: str) -> "ListFileViewRecordRequestBuilder":
        self._list_file_view_record_request.file_token = file_token
        self._list_file_view_record_request.paths["file_token"] = str(file_token)
        return self

    def build(self) -> ListFileViewRecordRequest:
        return self._list_file_view_record_request
