# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Media(object):
    _types = {
        "file_token": str,
        "file_name": str,
        "size": int,
        "mime_type": str,
    }

    def __init__(self, d=None):
        self.file_token: Optional[str] = None
        self.file_name: Optional[str] = None
        self.size: Optional[int] = None
        self.mime_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MediaBuilder":
        return MediaBuilder()


class MediaBuilder(object):
    def __init__(self) -> None:
        self._media = Media()

    def file_token(self, file_token: str) -> "MediaBuilder":
        self._media.file_token = file_token
        return self

    def file_name(self, file_name: str) -> "MediaBuilder":
        self._media.file_name = file_name
        return self

    def size(self, size: int) -> "MediaBuilder":
        self._media.size = size
        return self

    def mime_type(self, mime_type: str) -> "MediaBuilder":
        self._media.mime_type = mime_type
        return self

    def build(self) -> "Media":
        return self._media
