# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MediaUploadInfo(object):
    _types = {
        "file_name": str,
        "parent_type": str,
        "parent_node": str,
        "size": int,
        "extra": str,
    }

    def __init__(self, d=None):
        self.file_name: Optional[str] = None
        self.parent_type: Optional[str] = None
        self.parent_node: Optional[str] = None
        self.size: Optional[int] = None
        self.extra: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MediaUploadInfoBuilder":
        return MediaUploadInfoBuilder()


class MediaUploadInfoBuilder(object):
    def __init__(self) -> None:
        self._media_upload_info = MediaUploadInfo()

    def file_name(self, file_name: str) -> "MediaUploadInfoBuilder":
        self._media_upload_info.file_name = file_name
        return self

    def parent_type(self, parent_type: str) -> "MediaUploadInfoBuilder":
        self._media_upload_info.parent_type = parent_type
        return self

    def parent_node(self, parent_node: str) -> "MediaUploadInfoBuilder":
        self._media_upload_info.parent_node = parent_node
        return self

    def size(self, size: int) -> "MediaUploadInfoBuilder":
        self._media_upload_info.size = size
        return self

    def extra(self, extra: str) -> "MediaUploadInfoBuilder":
        self._media_upload_info.extra = extra
        return self

    def build(self) -> "MediaUploadInfo":
        return self._media_upload_info
