# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .move_file_request_body import MoveFileRequestBody


class MoveFileRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_token: Optional[str] = None
        self.request_body: Optional[MoveFileRequestBody] = None

    @staticmethod
    def builder() -> "MoveFileRequestBuilder":
        return MoveFileRequestBuilder()


class MoveFileRequestBuilder(object):

    def __init__(self) -> None:
        move_file_request = MoveFileRequest()
        move_file_request.http_method = HttpMethod.POST
        move_file_request.uri = "/open-apis/drive/v1/files/:file_token/move"
        move_file_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._move_file_request: MoveFileRequest = move_file_request

    def file_token(self, file_token: str) -> "MoveFileRequestBuilder":
        self._move_file_request.file_token = file_token
        self._move_file_request.paths["file_token"] = str(file_token)
        return self

    def request_body(self, request_body: MoveFileRequestBody) -> "MoveFileRequestBuilder":
        self._move_file_request.request_body = request_body
        self._move_file_request.body = request_body
        return self

    def build(self) -> MoveFileRequest:
        return self._move_file_request
