# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class PatchFileSubscriptionResponseBody(object):
    _types = {
        "subscription_id": str,
        "subscription_type": str,
        "is_subcribe": bool,
        "file_type": str,
    }

    def __init__(self, d=None):
        self.subscription_id: Optional[str] = None
        self.subscription_type: Optional[str] = None
        self.is_subcribe: Optional[bool] = None
        self.file_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchFileSubscriptionResponseBodyBuilder":
        return PatchFileSubscriptionResponseBodyBuilder()


class PatchFileSubscriptionResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_file_subscription_response_body = PatchFileSubscriptionResponseBody()

    def subscription_id(self, subscription_id: str) -> "PatchFileSubscriptionResponseBodyBuilder":
        self._patch_file_subscription_response_body.subscription_id = subscription_id
        return self

    def subscription_type(self, subscription_type: str) -> "PatchFileSubscriptionResponseBodyBuilder":
        self._patch_file_subscription_response_body.subscription_type = subscription_type
        return self

    def is_subcribe(self, is_subcribe: bool) -> "PatchFileSubscriptionResponseBodyBuilder":
        self._patch_file_subscription_response_body.is_subcribe = is_subcribe
        return self

    def file_type(self, file_type: str) -> "PatchFileSubscriptionResponseBodyBuilder":
        self._patch_file_subscription_response_body.file_type = file_type
        return self

    def build(self) -> "PatchFileSubscriptionResponseBody":
        return self._patch_file_subscription_response_body
