# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .permission_public_request import PermissionPublicRequest


class PatchPermissionPublicRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.type: Optional[str] = None
        self.token: Optional[str] = None
        self.request_body: Optional[PermissionPublicRequest] = None

    @staticmethod
    def builder() -> "PatchPermissionPublicRequestBuilder":
        return PatchPermissionPublicRequestBuilder()


class PatchPermissionPublicRequestBuilder(object):

    def __init__(self) -> None:
        patch_permission_public_request = PatchPermissionPublicRequest()
        patch_permission_public_request.http_method = HttpMethod.PATCH
        patch_permission_public_request.uri = "/open-apis/drive/v1/permissions/:token/public"
        patch_permission_public_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_permission_public_request: PatchPermissionPublicRequest = patch_permission_public_request

    def type(self, type: str) -> "PatchPermissionPublicRequestBuilder":
        self._patch_permission_public_request.type = type
        self._patch_permission_public_request.add_query("type", type)
        return self

    def token(self, token: str) -> "PatchPermissionPublicRequestBuilder":
        self._patch_permission_public_request.token = token
        self._patch_permission_public_request.paths["token"] = str(token)
        return self

    def request_body(self, request_body: PermissionPublicRequest) -> "PatchPermissionPublicRequestBuilder":
        self._patch_permission_public_request.request_body = request_body
        self._patch_permission_public_request.body = request_body
        return self

    def build(self) -> PatchPermissionPublicRequest:
        return self._patch_permission_public_request
