# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .docs_link import DocsLink
from .person import Person
from .text_run import TextRun


class ReplyElement(object):
    _types = {
        "type": str,
        "text_run": TextRun,
        "docs_link": DocsLink,
        "person": Person,
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.text_run: Optional[TextRun] = None
        self.docs_link: Optional[DocsLink] = None
        self.person: Optional[Person] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReplyElementBuilder":
        return ReplyElementBuilder()


class ReplyElementBuilder(object):
    def __init__(self) -> None:
        self._reply_element = ReplyElement()

    def type(self, type: str) -> "ReplyElementBuilder":
        self._reply_element.type = type
        return self

    def text_run(self, text_run: TextRun) -> "ReplyElementBuilder":
        self._reply_element.text_run = text_run
        return self

    def docs_link(self, docs_link: DocsLink) -> "ReplyElementBuilder":
        self._reply_element.docs_link = docs_link
        return self

    def person(self, person: Person) -> "ReplyElementBuilder":
        self._reply_element.person = person
        return self

    def build(self) -> "ReplyElement":
        return self._reply_element
