# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TmpDownloadUrl(object):
    _types = {
        "file_token": str,
        "tmp_download_url": str,
    }

    def __init__(self, d=None):
        self.file_token: Optional[str] = None
        self.tmp_download_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TmpDownloadUrlBuilder":
        return TmpDownloadUrlBuilder()


class TmpDownloadUrlBuilder(object):
    def __init__(self) -> None:
        self._tmp_download_url = TmpDownloadUrl()

    def file_token(self, file_token: str) -> "TmpDownloadUrlBuilder":
        self._tmp_download_url.file_token = file_token
        return self

    def tmp_download_url(self, tmp_download_url: str) -> "TmpDownloadUrlBuilder":
        self._tmp_download_url.tmp_download_url = tmp_download_url
        return self

    def build(self) -> "TmpDownloadUrl":
        return self._tmp_download_url
