# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TokenType(object):
    _types = {
        "token": str,
        "type": str,
    }

    def __init__(self, d=None):
        self.token: Optional[str] = None
        self.type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TokenTypeBuilder":
        return TokenTypeBuilder()


class TokenTypeBuilder(object):
    def __init__(self) -> None:
        self._token_type = TokenType()

    def token(self, token: str) -> "TokenTypeBuilder":
        self._token_type.token = token
        return self

    def type(self, type: str) -> "TokenTypeBuilder":
        self._token_type.type = type
        return self

    def build(self) -> "TokenType":
        return self._token_type
