# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .base_member import BaseMember


class UpdatePermissionMemberRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.need_notification: Optional[bool] = None
        self.type: Optional[str] = None
        self.token: Optional[str] = None
        self.member_id: Optional[str] = None
        self.request_body: Optional[BaseMember] = None

    @staticmethod
    def builder() -> "UpdatePermissionMemberRequestBuilder":
        return UpdatePermissionMemberRequestBuilder()


class UpdatePermissionMemberRequestBuilder(object):

    def __init__(self) -> None:
        update_permission_member_request = UpdatePermissionMemberRequest()
        update_permission_member_request.http_method = HttpMethod.PUT
        update_permission_member_request.uri = "/open-apis/drive/v1/permissions/:token/members/:member_id"
        update_permission_member_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._update_permission_member_request: UpdatePermissionMemberRequest = update_permission_member_request

    def need_notification(self, need_notification: bool) -> "UpdatePermissionMemberRequestBuilder":
        self._update_permission_member_request.need_notification = need_notification
        self._update_permission_member_request.add_query("need_notification", need_notification)
        return self

    def type(self, type: str) -> "UpdatePermissionMemberRequestBuilder":
        self._update_permission_member_request.type = type
        self._update_permission_member_request.add_query("type", type)
        return self

    def token(self, token: str) -> "UpdatePermissionMemberRequestBuilder":
        self._update_permission_member_request.token = token
        self._update_permission_member_request.paths["token"] = str(token)
        return self

    def member_id(self, member_id: str) -> "UpdatePermissionMemberRequestBuilder":
        self._update_permission_member_request.member_id = member_id
        self._update_permission_member_request.paths["member_id"] = str(member_id)
        return self

    def request_body(self, request_body: BaseMember) -> "UpdatePermissionMemberRequestBuilder":
        self._update_permission_member_request.request_body = request_body
        self._update_permission_member_request.body = request_body
        return self

    def build(self) -> UpdatePermissionMemberRequest:
        return self._update_permission_member_request
