# Code generated by Lark OpenAPI.

from typing import Any, Optional, IO

from lark_oapi.core.construct import init


class UploadAllFileRequestBody(object):
    _types = {
        "file_name": str,
        "parent_type": str,
        "parent_node": str,
        "size": int,
        "checksum": str,
        "file": IO[Any],
    }

    def __init__(self, d=None):
        self.file_name: Optional[str] = None
        self.parent_type: Optional[str] = None
        self.parent_node: Optional[str] = None
        self.size: Optional[int] = None
        self.checksum: Optional[str] = None
        self.file: Optional[IO[Any]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UploadAllFileRequestBodyBuilder":
        return UploadAllFileRequestBodyBuilder()


class UploadAllFileRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._upload_all_file_request_body = UploadAllFileRequestBody()

    def file_name(self, file_name: str) -> "UploadAllFileRequestBodyBuilder":
        self._upload_all_file_request_body.file_name = file_name
        return self

    def parent_type(self, parent_type: str) -> "UploadAllFileRequestBodyBuilder":
        self._upload_all_file_request_body.parent_type = parent_type
        return self

    def parent_node(self, parent_node: str) -> "UploadAllFileRequestBodyBuilder":
        self._upload_all_file_request_body.parent_node = parent_node
        return self

    def size(self, size: int) -> "UploadAllFileRequestBodyBuilder":
        self._upload_all_file_request_body.size = size
        return self

    def checksum(self, checksum: str) -> "UploadAllFileRequestBodyBuilder":
        self._upload_all_file_request_body.checksum = checksum
        return self

    def file(self, file: IO[Any]) -> "UploadAllFileRequestBodyBuilder":
        self._upload_all_file_request_body.file = file
        return self

    def build(self) -> "UploadAllFileRequestBody":
        return self._upload_all_file_request_body
