# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .upload_all_media_request_body import UploadAllMediaRequestBody


class UploadAllMediaRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[UploadAllMediaRequestBody] = None

    @staticmethod
    def builder() -> "UploadAllMediaRequestBuilder":
        return UploadAllMediaRequestBuilder()


class UploadAllMediaRequestBuilder(object):

    def __init__(self) -> None:
        upload_all_media_request = UploadAllMediaRequest()
        upload_all_media_request.http_method = HttpMethod.POST
        upload_all_media_request.uri = "/open-apis/drive/v1/medias/upload_all"
        upload_all_media_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._upload_all_media_request: UploadAllMediaRequest = upload_all_media_request

    def request_body(self, request_body: UploadAllMediaRequestBody) -> "UploadAllMediaRequestBuilder":
        self._upload_all_media_request.request_body = request_body
        self._upload_all_media_request.body = request_body
        return self

    def build(self) -> UploadAllMediaRequest:
        return self._upload_all_media_request
