# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .upload_finish_file_request_body import UploadFinishFileRequestBody


class UploadFinishFileRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[UploadFinishFileRequestBody] = None

    @staticmethod
    def builder() -> "UploadFinishFileRequestBuilder":
        return UploadFinishFileRequestBuilder()


class UploadFinishFileRequestBuilder(object):

    def __init__(self) -> None:
        upload_finish_file_request = UploadFinishFileRequest()
        upload_finish_file_request.http_method = HttpMethod.POST
        upload_finish_file_request.uri = "/open-apis/drive/v1/files/upload_finish"
        upload_finish_file_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._upload_finish_file_request: UploadFinishFileRequest = upload_finish_file_request

    def request_body(self, request_body: UploadFinishFileRequestBody) -> "UploadFinishFileRequestBuilder":
        self._upload_finish_file_request.request_body = request_body
        self._upload_finish_file_request.body = request_body
        return self

    def build(self) -> UploadFinishFileRequest:
        return self._upload_finish_file_request
