# Code generated by Lark OpenAPI.

from typing import Any, Optional, IO

from lark_oapi.core.construct import init


class UploadPartMediaRequestBody(object):
    _types = {
        "upload_id": str,
        "seq": int,
        "size": int,
        "checksum": str,
        "file": IO[Any],
    }

    def __init__(self, d=None):
        self.upload_id: Optional[str] = None
        self.seq: Optional[int] = None
        self.size: Optional[int] = None
        self.checksum: Optional[str] = None
        self.file: Optional[IO[Any]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UploadPartMediaRequestBodyBuilder":
        return UploadPartMediaRequestBodyBuilder()


class UploadPartMediaRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._upload_part_media_request_body = UploadPartMediaRequestBody()

    def upload_id(self, upload_id: str) -> "UploadPartMediaRequestBodyBuilder":
        self._upload_part_media_request_body.upload_id = upload_id
        return self

    def seq(self, seq: int) -> "UploadPartMediaRequestBodyBuilder":
        self._upload_part_media_request_body.seq = seq
        return self

    def size(self, size: int) -> "UploadPartMediaRequestBodyBuilder":
        self._upload_part_media_request_body.size = size
        return self

    def checksum(self, checksum: str) -> "UploadPartMediaRequestBodyBuilder":
        self._upload_part_media_request_body.checksum = checksum
        return self

    def file(self, file: IO[Any]) -> "UploadPartMediaRequestBodyBuilder":
        self._upload_part_media_request_body.file = file
        return self

    def build(self) -> "UploadPartMediaRequestBody":
        return self._upload_part_media_request_body
