# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .file_upload_info import FileUploadInfo


class UploadPrepareFileRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[FileUploadInfo] = None

    @staticmethod
    def builder() -> "UploadPrepareFileRequestBuilder":
        return UploadPrepareFileRequestBuilder()


class UploadPrepareFileRequestBuilder(object):

    def __init__(self) -> None:
        upload_prepare_file_request = UploadPrepareFileRequest()
        upload_prepare_file_request.http_method = HttpMethod.POST
        upload_prepare_file_request.uri = "/open-apis/drive/v1/files/upload_prepare"
        upload_prepare_file_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._upload_prepare_file_request: UploadPrepareFileRequest = upload_prepare_file_request

    def request_body(self, request_body: FileUploadInfo) -> "UploadPrepareFileRequestBuilder":
        self._upload_prepare_file_request.request_body = request_body
        self._upload_prepare_file_request.body = request_body
        return self

    def build(self) -> UploadPrepareFileRequest:
        return self._upload_prepare_file_request
