# Code generated by Lark OpenAPI.

import io
from typing import Optional

from requests_toolbelt import MultipartEncoder

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from lark_oapi.core.utils import Files
from ..model.batch_get_tmp_download_url_media_request import BatchGetTmpDownloadUrlMediaRequest
from ..model.batch_get_tmp_download_url_media_response import BatchGetTmpDownloadUrlMediaResponse
from ..model.download_media_request import DownloadMediaRequest
from ..model.download_media_response import DownloadMediaResponse
from ..model.upload_all_media_request import UploadAllMediaRequest
from ..model.upload_all_media_response import UploadAllMediaResponse
from ..model.upload_finish_media_request import UploadFinishMediaRequest
from ..model.upload_finish_media_response import UploadFinishMediaResponse
from ..model.upload_part_media_request import UploadPartMediaRequest
from ..model.upload_part_media_response import UploadPartMediaResponse
from ..model.upload_prepare_media_request import UploadPrepareMediaRequest
from ..model.upload_prepare_media_response import UploadPrepareMediaResponse


class Media(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_get_tmp_download_url(self, request: BatchGetTmpDownloadUrlMediaRequest,
                                   option: Optional[RequestOption] = None) -> BatchGetTmpDownloadUrlMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchGetTmpDownloadUrlMediaResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       BatchGetTmpDownloadUrlMediaResponse)
        response.raw = resp

        return response

    async def abatch_get_tmp_download_url(self, request: BatchGetTmpDownloadUrlMediaRequest, option: Optional[
        RequestOption] = None) -> BatchGetTmpDownloadUrlMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchGetTmpDownloadUrlMediaResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       BatchGetTmpDownloadUrlMediaResponse)
        response.raw = resp

        return response

    def download(self, request: DownloadMediaRequest, option: Optional[RequestOption] = None) -> DownloadMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 处理二进制流
        content_type = resp.headers.get(CONTENT_TYPE)
        response: DownloadMediaResponse = DownloadMediaResponse()
        if 200 <= resp.status_code < 300:
            response.code = 0
            response.file = io.BytesIO(resp.content)
            response.file_name = Files.parse_file_name(resp.headers)
        elif content_type is not None and content_type.startswith(APPLICATION_JSON):
            response = JSON.unmarshal(str(resp.content, UTF_8), DownloadMediaResponse)

        response.raw = resp
        return response

    async def adownload(self, request: DownloadMediaRequest,
                        option: Optional[RequestOption] = None) -> DownloadMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 处理二进制流
        content_type = resp.headers.get(CONTENT_TYPE)
        response: DownloadMediaResponse = DownloadMediaResponse()
        if 200 <= resp.status_code < 300:
            response.code = 0
            response.file = io.BytesIO(resp.content)
            response.file_name = Files.parse_file_name(resp.headers)
        elif content_type is not None and content_type.startswith(APPLICATION_JSON):
            response = JSON.unmarshal(str(resp.content, UTF_8), DownloadMediaResponse)

        response.raw = resp
        return response

    def upload_all(self, request: UploadAllMediaRequest,
                   option: Optional[RequestOption] = None) -> UploadAllMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            form_data = MultipartEncoder(Files.parse_form_data(request.body))
            request.body = form_data
            option.headers[CONTENT_TYPE] = form_data.content_type

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UploadAllMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadAllMediaResponse)
        response.raw = resp

        return response

    async def aupload_all(self, request: UploadAllMediaRequest,
                          option: Optional[RequestOption] = None) -> UploadAllMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 解析文件
        request.files = Files.extract_files(request.body)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UploadAllMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadAllMediaResponse)
        response.raw = resp

        return response

    def upload_finish(self, request: UploadFinishMediaRequest,
                      option: Optional[RequestOption] = None) -> UploadFinishMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UploadFinishMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadFinishMediaResponse)
        response.raw = resp

        return response

    async def aupload_finish(self, request: UploadFinishMediaRequest,
                             option: Optional[RequestOption] = None) -> UploadFinishMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UploadFinishMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadFinishMediaResponse)
        response.raw = resp

        return response

    def upload_part(self, request: UploadPartMediaRequest,
                    option: Optional[RequestOption] = None) -> UploadPartMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            form_data = MultipartEncoder(Files.parse_form_data(request.body))
            request.body = form_data
            option.headers[CONTENT_TYPE] = form_data.content_type

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UploadPartMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadPartMediaResponse)
        response.raw = resp

        return response

    async def aupload_part(self, request: UploadPartMediaRequest,
                           option: Optional[RequestOption] = None) -> UploadPartMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 解析文件
        request.files = Files.extract_files(request.body)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UploadPartMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadPartMediaResponse)
        response.raw = resp

        return response

    def upload_prepare(self, request: UploadPrepareMediaRequest,
                       option: Optional[RequestOption] = None) -> UploadPrepareMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UploadPrepareMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadPrepareMediaResponse)
        response.raw = resp

        return response

    async def aupload_prepare(self, request: UploadPrepareMediaRequest,
                              option: Optional[RequestOption] = None) -> UploadPrepareMediaResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UploadPrepareMediaResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadPrepareMediaResponse)
        response.raw = resp

        return response
