# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.auth_permission_member_request import AuthPermissionMemberRequest
from ..model.auth_permission_member_response import AuthPermissionMemberResponse
from ..model.create_permission_member_request import CreatePermissionMemberRequest
from ..model.create_permission_member_response import CreatePermissionMemberResponse
from ..model.delete_permission_member_request import DeletePermissionMemberRequest
from ..model.delete_permission_member_response import DeletePermissionMemberResponse
from ..model.list_permission_member_request import ListPermissionMemberRequest
from ..model.list_permission_member_response import ListPermissionMemberResponse
from ..model.transfer_owner_permission_member_request import TransferOwnerPermissionMemberRequest
from ..model.transfer_owner_permission_member_response import TransferOwnerPermissionMemberResponse
from ..model.update_permission_member_request import UpdatePermissionMemberRequest
from ..model.update_permission_member_response import UpdatePermissionMemberResponse


class PermissionMember(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def auth(self, request: AuthPermissionMemberRequest,
             option: Optional[RequestOption] = None) -> AuthPermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AuthPermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), AuthPermissionMemberResponse)
        response.raw = resp

        return response

    async def aauth(self, request: AuthPermissionMemberRequest,
                    option: Optional[RequestOption] = None) -> AuthPermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AuthPermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), AuthPermissionMemberResponse)
        response.raw = resp

        return response

    def create(self, request: CreatePermissionMemberRequest,
               option: Optional[RequestOption] = None) -> CreatePermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreatePermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CreatePermissionMemberResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreatePermissionMemberRequest,
                      option: Optional[RequestOption] = None) -> CreatePermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreatePermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CreatePermissionMemberResponse)
        response.raw = resp

        return response

    def delete(self, request: DeletePermissionMemberRequest,
               option: Optional[RequestOption] = None) -> DeletePermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeletePermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  DeletePermissionMemberResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeletePermissionMemberRequest,
                      option: Optional[RequestOption] = None) -> DeletePermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeletePermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  DeletePermissionMemberResponse)
        response.raw = resp

        return response

    def list(self, request: ListPermissionMemberRequest,
             option: Optional[RequestOption] = None) -> ListPermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListPermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), ListPermissionMemberResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListPermissionMemberRequest,
                    option: Optional[RequestOption] = None) -> ListPermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListPermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8), ListPermissionMemberResponse)
        response.raw = resp

        return response

    def transfer_owner(self, request: TransferOwnerPermissionMemberRequest,
                       option: Optional[RequestOption] = None) -> TransferOwnerPermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: TransferOwnerPermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                         TransferOwnerPermissionMemberResponse)
        response.raw = resp

        return response

    async def atransfer_owner(self, request: TransferOwnerPermissionMemberRequest,
                              option: Optional[RequestOption] = None) -> TransferOwnerPermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: TransferOwnerPermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                         TransferOwnerPermissionMemberResponse)
        response.raw = resp

        return response

    def update(self, request: UpdatePermissionMemberRequest,
               option: Optional[RequestOption] = None) -> UpdatePermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdatePermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  UpdatePermissionMemberResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdatePermissionMemberRequest,
                      option: Optional[RequestOption] = None) -> UpdatePermissionMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdatePermissionMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  UpdatePermissionMemberResponse)
        response.raw = resp

        return response
