# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class FileLike(object):
    _types = {
        "user_id": int,
        "last_liked_time": int,
        "user_name": str,
        "user_en_name": str,
        "user_avatar_url": str,
        "user_is_desensitized": bool,
    }

    def __init__(self, d=None):
        self.user_id: Optional[int] = None
        self.last_liked_time: Optional[int] = None
        self.user_name: Optional[str] = None
        self.user_en_name: Optional[str] = None
        self.user_avatar_url: Optional[str] = None
        self.user_is_desensitized: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileLikeBuilder":
        return FileLikeBuilder()


class FileLikeBuilder(object):
    def __init__(self) -> None:
        self._file_like = FileLike()

    def user_id(self, user_id: int) -> "FileLikeBuilder":
        self._file_like.user_id = user_id
        return self

    def last_liked_time(self, last_liked_time: int) -> "FileLikeBuilder":
        self._file_like.last_liked_time = last_liked_time
        return self

    def user_name(self, user_name: str) -> "FileLikeBuilder":
        self._file_like.user_name = user_name
        return self

    def user_en_name(self, user_en_name: str) -> "FileLikeBuilder":
        self._file_like.user_en_name = user_en_name
        return self

    def user_avatar_url(self, user_avatar_url: str) -> "FileLikeBuilder":
        self._file_like.user_avatar_url = user_avatar_url
        return self

    def user_is_desensitized(self, user_is_desensitized: bool) -> "FileLikeBuilder":
        self._file_like.user_is_desensitized = user_is_desensitized
        return self

    def build(self) -> "FileLike":
        return self._file_like
