# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MyLike(object):
    _types = {
        "last_liked_time": int,
        "file_token": str,
        "file_type": str,
        "file_name": str,
        "file_url": str,
        "file_is_deleted": bool,
    }

    def __init__(self, d=None):
        self.last_liked_time: Optional[int] = None
        self.file_token: Optional[str] = None
        self.file_type: Optional[str] = None
        self.file_name: Optional[str] = None
        self.file_url: Optional[str] = None
        self.file_is_deleted: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MyLikeBuilder":
        return MyLikeBuilder()


class MyLikeBuilder(object):
    def __init__(self) -> None:
        self._my_like = MyLike()

    def last_liked_time(self, last_liked_time: int) -> "MyLikeBuilder":
        self._my_like.last_liked_time = last_liked_time
        return self

    def file_token(self, file_token: str) -> "MyLikeBuilder":
        self._my_like.file_token = file_token
        return self

    def file_type(self, file_type: str) -> "MyLikeBuilder":
        self._my_like.file_type = file_type
        return self

    def file_name(self, file_name: str) -> "MyLikeBuilder":
        self._my_like.file_name = file_name
        return self

    def file_url(self, file_url: str) -> "MyLikeBuilder":
        self._my_like.file_url = file_url
        return self

    def file_is_deleted(self, file_is_deleted: bool) -> "MyLikeBuilder":
        self._my_like.file_is_deleted = file_is_deleted
        return self

    def build(self) -> "MyLike":
        return self._my_like
