# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetAttachmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.token: Optional[str] = None

    @staticmethod
    def builder() -> "GetAttachmentRequestBuilder":
        return GetAttachmentRequestBuilder()


class GetAttachmentRequestBuilder(object):

    def __init__(self) -> None:
        get_attachment_request = GetAttachmentRequest()
        get_attachment_request.http_method = HttpMethod.GET
        get_attachment_request.uri = "/open-apis/ehr/v1/attachments/:token"
        get_attachment_request.token_types = {AccessTokenType.TENANT}
        self._get_attachment_request: GetAttachmentRequest = get_attachment_request

    def token(self, token: str) -> "GetAttachmentRequestBuilder":
        self._get_attachment_request.token = token
        self._get_attachment_request.paths["token"] = str(token)
        return self

    def build(self) -> GetAttachmentRequest:
        return self._get_attachment_request
