# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListEmployeeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.view: Optional[str] = None
        self.status: Optional[List[int]] = None
        self.type: Optional[List[int]] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.user_id_type: Optional[str] = None
        self.user_ids: Optional[List[str]] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None

    @staticmethod
    def builder() -> "ListEmployeeRequestBuilder":
        return ListEmployeeRequestBuilder()


class ListEmployeeRequestBuilder(object):

    def __init__(self) -> None:
        list_employee_request = ListEmployeeRequest()
        list_employee_request.http_method = HttpMethod.GET
        list_employee_request.uri = "/open-apis/ehr/v1/employees"
        list_employee_request.token_types = {AccessTokenType.TENANT}
        self._list_employee_request: ListEmployeeRequest = list_employee_request

    def view(self, view: str) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.view = view
        self._list_employee_request.add_query("view", view)
        return self

    def status(self, status: List[int]) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.status = status
        self._list_employee_request.add_query("status", status)
        return self

    def type(self, type: List[int]) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.type = type
        self._list_employee_request.add_query("type", type)
        return self

    def start_time(self, start_time: int) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.start_time = start_time
        self._list_employee_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: int) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.end_time = end_time
        self._list_employee_request.add_query("end_time", end_time)
        return self

    def user_id_type(self, user_id_type: str) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.user_id_type = user_id_type
        self._list_employee_request.add_query("user_id_type", user_id_type)
        return self

    def user_ids(self, user_ids: List[str]) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.user_ids = user_ids
        self._list_employee_request.add_query("user_ids", user_ids)
        return self

    def page_token(self, page_token: str) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.page_token = page_token
        self._list_employee_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListEmployeeRequestBuilder":
        self._list_employee_request.page_size = page_size
        self._list_employee_request.add_query("page_size", page_size)
        return self

    def build(self) -> ListEmployeeRequest:
        return self._list_employee_request
